<?php

/**
 * The sub-class that manages the clinic custom post type
 *
 * @link       https://aheadoftheweb.com/
 * @since      1.0.0
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin
 */

/**
 * The sub-class that manages the clinic custom post type
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin
 * @author     Graeme <Gibson>
 */
class Aow_Hub_Node_CPT_Clinic extends Aow_Hub_Node_CPT {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	public $posttype = 'clinic';

	public $singular = 'Clinic';
	
	public $key = 'clinicid';
	
	public $endpoint = '';
	
	
	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin ) {
		$this->admin = $plugin;
		parent::__construct(
			array( __( 'Clinic', 'clinic' ), __( 'Clinics', 'clinic' ), 'clinic' ),
			array( 'supports' => array( 'title', 'editor', 'excerpt', 'thumbnail', 'page-attributes' ),
				   'hierarchical' => true,
				   'capability_type'       => 'page',
				   'rewrite'	  => array(
						'slug'                  => 'our',
						'with_front'            => true,
						'pages'                 => false,
						'feeds'                 => false,
						),
					)
				);
		
	}
	
	public function get_meta( $cip ){
		$meta_fields = array(
			'cip'				=> json_encode( $cip ),
			'clinic_name'		=> $cip->ClinicName,
			'clinicid'			=> $cip->ClinicInfoPackage->HUBinfo->hubID,
			'description'		=> nl2br( $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Description ),
		    'mon' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 0 ),
		    'tue' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 1 ),
		    'wed' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 2 ),
		    'thu' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 3 ),
		    'fri' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 4 ),
		    'sat' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 5 ),
		    'sun' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 6 ),
		    'street'			=> $cip->ClinicInfoPackage->ContactInfo->Address->Street,
		    'postal_code'		=> $cip->ClinicInfoPackage->ContactInfo->Address->PostalCode,
		    'cityid'			=> $this->aow_get_postid_from_meta( $cip->ClinicInfoPackage->ContactInfo->Address->CityID, 'cityid' ),
			'city'				=> $cip->ClinicInfoPackage->ContactInfo->Address->City,
			'province'			=> $cip->ClinicInfoPackage->ContactInfo->Address->Province,
			'country'			=> $cip->ClinicInfoPackage->ContactInfo->Address->Country,
		    'websiteurl'		=> $cip->ClinicInfoPackage->ContactInfo->ContactInfo->WebsiteURL,
		    'email'				=> $cip->ClinicInfoPackage->ContactInfo->ContactInfo->Email,
		    'telephone'			=> $cip->ClinicInfoPackage->ContactInfo->ContactInfo->Telephone,
		    'fax'				=> $cip->ClinicInfoPackage->ContactInfo->ContactInfo->Fax,		    
		    'latitude' 			=> $cip->ClinicInfoPackage->ContactInfo->Address->GeoCoordinates,
		    'longitude' 		=> $cip->ClinicInfoPackage->ContactInfo->Address->GeoCoordinates,
		    'lat_long' 			=> $cip->ClinicInfoPackage->ContactInfo->Address->GeoCoordinates,
		    'staff'				=> $this->aow_get_postid_from_meta( $cip->ClinicInfoPackage->ClinicPersonnel->Personnel->Dentists, 'staffid' ),
		    'services'			=> $this->aow_get_postid_from_meta( $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Services, 'serviceid' ),
			'languages'			=> $this->aow_get_postid_from_meta( $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Languages, 'languageid' ),
			'logo'				=> $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Logo,
			'image'				=> $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Image,
			'map'				=> $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Map,
		    'facebookurl'		=> $cip->ClinicInfoPackage->ClinicThirdParty->SocialMedia->FacebookURL,
		    'twitterurl'		=> $cip->ClinicInfoPackage->ClinicThirdParty->SocialMedia->TwitterID,
		    'youtubeid'			=> $cip->ClinicInfoPackage->ClinicThirdParty->SocialMedia->YouTubeID,
		    'google_plus'		=> $cip->ClinicInfoPackage->ClinicThirdParty->SocialMedia->GoogleURL,
		    'linked'			=> $cip->ClinicInfoPackage->ClinicThirdParty->SocialMedia->LinkedInURL,
		    'yelp_id'			=> $cip->ClinicInfoPackage->ClinicThirdParty->ServiceProviders->YelpID,
		    'languages'			=> $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Languages,
		    'yelp_reviews_id'	=> $cip->ClinicInfoPackage->ClinicThirdParty->SocialMedia->YelpURL,
		);
		
		$meta_fields = $this->get_closure_status( $cip->ClinicInfoPackage, $meta_fields );
		
		$meta_fields = $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 0, $meta_fields );
		return $meta_fields;
	}
	
	/**
	 * format time
	 * @param string $time
	 */
	public function get_hours( $array, $key, $meta_fields = FALSE ){
		if( $meta_fields && is_array( $meta_fields ) ){
			$days = array(
				0 => 'mon',
				1 => 'tue',
				2 => 'wed',
				3 => 'thu',
				4 => 'fri',
				5 => 'sat',
				6 => 'sun',
			);
			foreach ( $days as $k => $v ){
				$meta_fields[ $v . '_open' ] = ( $array[ $k ][ 2 ] == '0' ) ? $array[ $k ][ 0 ] : 'closed';
				$meta_fields[ $v . '_closed' ] = ( $array[ $k ][ 2 ] == '0' ) ? $array[ $k ][ 1 ] : 'closed';
				$meta_fields[ $v . '_msg' ] = ( $array[ $k ][ 2 ] == '2' ) ? $array[ $k ][ 3 ] : FALSE;
			}
			return $meta_fields;
		}
		$time = $this->formatTime( $array[ $key ] );
		return $time;
	}
		
	public function formatTime($time)
	{		
		if ($time[2] == 1 or (!$time[0] and !$time[1])) {
			$hour = 'CLOSED';
			return $hour;
		}
		$open_time = number_format(($time[0]%2400)/100,2);
		$close_time = number_format(($time[1]%1200)/100,2);

		$openAP = ($time[0]<1200)?"AM":"PM";
		$closeAP = ($time[1]<1200)?"AM":"PM";	
		/*temp fix for 12:30 closing time problem */
		if ($time[1]==="1230") {$close_time = "12.30";}

		$open_time = str_replace(".",":",$open_time) . $openAP;
		$close_time = str_replace(".",":",$close_time) . $closeAP;		
		$note = (isset($time[3]) and $time[3])?" " . $time[3]:null;
		$hour = $open_time.' - '.$close_time . $note;

		return $hour;
	}
	
	public function aow_get_postid_from_meta( $meta_values = array( true ), $meta_key = FALSE ){
		if( !is_array( $meta_values ) ){ $meta_values = array( $meta_values ); }
		$post_ids = array();
		global $wpdb;
		if( is_array( $meta_values ) && $meta_key ){
			foreach( $meta_values as $meta_value ){	
				$results = $wpdb->get_results( "select post_id from $wpdb->postmeta where meta_key = '$meta_key' AND meta_value = '$meta_value'" );
				if( !empty( $results ) ){
					$post_ids[] = $results[ 0 ]->post_id;
				}
			}
		}
		return $post_ids;
	}
	
	public function get_closure_status( $cip, $meta_fields ){
		
		
		//'emergency_status'	=> $this->translate_temp_closure( $cip->ClinicInfoPackage->ClosureStatus->temporary_closure ),
		//	'emergency_message'	=> $cip->ClinicInfoPackage->ClosureStatus->closure_reason,
		
		if( property_exists( $cip, 'ClosureStatus' ) ){
			switch( $cip->ClosureStatus->temporary_closure ){
				case '0' :
					$closure_status = '1';
					break;
				case '1' :
					$closure_status = '3';
					break;
				default:
					$closure_status = '1';
			}
			
			$meta_fields[ 'emergency_status' ] = $closure_status;
			$meta_fields[ 'emergency_message' ] = $cip->ClosureStatus->closure_reason;
		}
		
		
		
		/*
		on HUB
		0 : Open
		1 : Closed
		
		on 123Dentist
		1 : Open
		2 : Available On-Call
		3 : Temporarily Closed
		*/
		
		return $meta_fields;
	}

}
?>