<?php
/**
 * Adds Clinic_Promotions widget.
 */

class Aow_Hub_Node_Widget_Clinic_Promotions extends WP_Widget {

	
	private $admin;
	
  /**

   * Register widget with WordPress

   */

  public function __construct( $admin ) {

    parent::__construct(

      'aow_hub_node_widget_clinic_promotions', // Base ID

      __( 'AOW HUB NODE Clinic Promotions', 'text_domain' ), // Widget Name

      array( 'description' => __( 'Display Clinic Promotions', 'text_domain' ), ) // Widget Description

    );
	  
	$this->admin = $admin;

  }

  /**

   * Front-end display of widget

   */

  public function widget( $args, $instance ) {
    //Our variables from the widget settings.
    $title = apply_filters( 'widget_title', $instance[ 'title' ] );
	$id = ( array_key_exists( 'id', $instance ) ) ? $instance[ 'id' ] : '';
    $name = $instance['content'];
	 //$show_info = isset( $instance['show_info'] ) ? $instance['show_info'] : false;
    //$sharecontenthaswidgettitle = $this->admin->get_option( "sc123_promo_hastitle" );
    //$sharecontentwidgettitle = $this->admin->get_option( "sc123_promo_title" );
    //$sharecontentcontent = $this->admin->get_option( "sc123_promo_content" );
    //$sharecontentdisplaystate = $this->admin->get_option( "sc123_promo_displaystate" );
	  global $aow_get_clinic_info_id;
	  $aow_get_clinic_info_id = $id;
	  $promo_array = $this->admin->helper->get_promo_array();
	  $title = ( $promo_array[ 'title' ] ) ? $promo_array[ 'title' ] : '123Dentist Promotions';
	  $content = ( $promo_array[ 'content' ] ) ? $promo_array[ 'content' ] : 'There are no current promotions.';
	  
	  echo $args[ 'before_widget' ];
      echo $args[ 'before_title' ] . $title . $args[ 'after_title' ]; 
	  echo $content;
      echo $args[ 'after_widget' ];
	  
	  /*
	 // Display widget content 
    if($instance['show_info'] == 'on'){
            echo $args[ 'before_widget' ];
            // Display the widget title 
                if ( $title )
                echo $args[ 'before_title' ] . $title . $args[ 'after_title' ];
            //Display the name 

            if ($instance['content']){
                echo $instance['content'];
            }else{
                echo 'There are no current promotions.';
            }
            echo $args[ 'after_widget' ];
    }else{
        if($sharecontentdisplaystate=="no"){
            return '';
        }
            echo $args[ 'before_widget' ];
            // Display the widget title 
            if($sharecontenthaswidgettitle=="no"){
                if ( $title )
                echo $args[ 'before_title' ] . $title . $args[ 'after_title' ];
            }else{
                echo $args[ 'before_title' ] . $sharecontentwidgettitle . $args[ 'after_title' ];
            }
            //Display the name 

            if($sharecontentcontent){
                echo $sharecontentcontent;
			}
            echo $args[ 'after_widget' ];
    }
	  */
  }


  /**

   * Back-end widget form

   */


/**
			 * Sanitize widget form values as they are saved.
			 */
			public function update( $new_instance, $old_instance ) {
				//Strip tags from title and name to remove HTML 
				$instance['title'] = strip_tags( $new_instance['title'] );
				$instance['content'] = ( $new_instance['content'] );
				$instance['show_info'] = $new_instance['show_info'];
				$instance['id'] = $new_instance['id'];
				return $instance;
			} 
          /**
			 * Back-end widget form
			 */
			 public function form( $instance ) {
			 	// Get title if there is one, if not set default title
				$defaults = array( 'title' => __('Ahead of the Web Promotions', 'example'), 'show_info' => true, 'id' => '' );
				 
			$instance = wp_parse_args( (array) $instance, $defaults );
			

?>
			<p>
  <label for="<?php echo $this->get_field_id( 'id' ); ?>">
    <?php _e( 'ID:' ); ?>
  </label>
  <input class="widefat" id="<?php echo $this->get_field_id( 'id' ); ?>" name="<?php echo $this->get_field_name( 'id' ); ?>" type="text" value="<?php echo esc_attr( $instance[ 'id' ] ); ?>" />
</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo strlen($instance['title'])==0?"Ahead of the Web Promotions":$instance['title']; ?>" style="width:95%;" />
			</p>
           
           <p>
				<label for="<?php echo $this->get_field_id( 'content' ); ?>">HTML Content</label>
				<textarea id="<?php echo $this->get_field_id( 'content' ); ?>" name="<?php echo $this->get_field_name( 'content' ); ?>" style="width:100%;"><?php echo $instance['content']; ?></textarea>
			</p>
			<p>
				<input class="checkbox" type="checkbox" value="on" <?php checked("on",$instance['show_info'], true ); ?> id="<?php echo $this->get_field_id( 'show_info' ); ?>" name="<?php echo $this->get_field_name( 'show_info' ); ?>" /> 
				<label for="<?php echo $this->get_field_id( 'show_info' ); ?>"><?php _e('Override Parent Content?', 'example'); ?></label>
			</p>
		<?php
		}

}
