<?php

/**
 * The sub-class that manages the clinic custom post type
 *
 * @link       https://aheadoftheweb.com/
 * @since      1.0.0
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin
 */

/**
 * The sub-class that manages the clinic custom post type
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin
 * @author     Graeme <Gibson>
 */
class Aow_Hub_Node_CPT_Clinic extends Aow_Hub_Node_CPT {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	public $posttype = 'clinic';

	public $singular = 'Clinic';
	
	public $key = 'clinicid';
	
	public $name = 'clinic_name';
	
	public $endpoint = '';
	
	
	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin, $active = 0 ) {
		$this->admin = $plugin;
		$active = 1;
		if( $active ){
			parent::__construct(
				array( __( 'Clinic', 'clinic' ), __( 'Clinics', 'clinic' ), 'clinic' ),
				array( 'supports' => array( 'title', 'editor', 'excerpt', 'thumbnail', 'page-attributes' ),
					   'hierarchical' => true,
					   'capability_type'       => 'page',
					   'rewrite'	  => array(
							'slug'                  => 'location',
							'with_front'            => true,
							'pages'                 => false,
							'feeds'                 => false,
							),
						)
					);
		}
		
	}
	
	public function get_meta( $cip, $old = FALSE ){
		$meta_fields = array();
		if( $old ){
			$meta_fields = array(
				'cip'				=> json_encode( $cip ),
				'clinic_name'		=> $cip->ClinicName,
				'clinicid'			=> $cip->ClinicInfoPackage->HUBinfo->hubID,
				'description'		=> nl2br( $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Description ),
				//'mon' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 0 ),
				//'tue' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 1 ),
				//'wed' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 2 ),
				//'thu' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 3 ),
				//'fri' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 4 ),
				//'sat' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 5 ),
				//'sun' 				=> $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 6 ),
				'street'			=> $cip->ClinicInfoPackage->ContactInfo->Address->Street,
				'postal_code'		=> $cip->ClinicInfoPackage->ContactInfo->Address->PostalCode,
				'cityid'			=> $this->aow_get_postid_from_meta( $cip->ClinicInfoPackage->ContactInfo->Address->CityID, 'cityid' ),
				'city'				=> $cip->ClinicInfoPackage->ContactInfo->Address->City,
				'province'			=> $cip->ClinicInfoPackage->ContactInfo->Address->Province,
				'country'			=> $cip->ClinicInfoPackage->ContactInfo->Address->Country,
				'websiteurl'		=> $cip->ClinicInfoPackage->ContactInfo->ContactInfo->WebsiteURL,
				'email'				=> $cip->ClinicInfoPackage->ContactInfo->ContactInfo->Email,
				'telephone'			=> $cip->ClinicInfoPackage->ContactInfo->ContactInfo->Telephone,
				'fax'				=> $cip->ClinicInfoPackage->ContactInfo->ContactInfo->Fax,		    
				'latitude' 			=> $cip->ClinicInfoPackage->ContactInfo->Address->GeoCoordinates,
				'longitude' 		=> $cip->ClinicInfoPackage->ContactInfo->Address->GeoCoordinates,
				'lat_long' 			=> $cip->ClinicInfoPackage->ContactInfo->Address->GeoCoordinates,
				'staff'				=> $this->aow_get_postid_from_meta( $cip->ClinicInfoPackage->ClinicPersonnel->Personnel->Dentists, 'staffid' ),
				'services'			=> $this->aow_get_postid_from_meta( $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Services, 'serviceid' ),
				'languages'			=> $this->aow_get_postid_from_meta( $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Languages, 'languageid' ),
				'logo'				=> $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Logo,
				'image'				=> $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Image,
				'map'				=> $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Map,
				'facebookurl'		=> $cip->ClinicInfoPackage->ClinicThirdParty->SocialMedia->FacebookURL,
				'twitterurl'		=> $cip->ClinicInfoPackage->ClinicThirdParty->SocialMedia->TwitterID,
				'youtubeid'			=> $cip->ClinicInfoPackage->ClinicThirdParty->SocialMedia->YouTubeID,
				'google_plus'		=> $cip->ClinicInfoPackage->ClinicThirdParty->SocialMedia->GoogleURL,
				'linked'			=> $cip->ClinicInfoPackage->ClinicThirdParty->SocialMedia->LinkedInURL,
				'yelp_id'			=> $cip->ClinicInfoPackage->ClinicThirdParty->ServiceProviders->YelpID,
				'languages'			=> $cip->ClinicInfoPackage->ClinicProfile->{'123dentistProfile'}->Languages,
				'yelp_reviews_id'	=> $cip->ClinicInfoPackage->ClinicThirdParty->SocialMedia->YelpURL,
			);

			$meta_fields = $this->get_closure_status( $cip->ClinicInfoPackage, $meta_fields );

			$meta_fields = $this->get_hours( $cip->ClinicInfoPackage->OpeningHours->ClinicHours, 'all', $meta_fields );
		}else{
			
			$meta_fields = array(
				'clinic_name'		=> $cip->clinic_name,
				'clinicid'			=> $cip->ci_hubid,
				'description'		=> nl2br( $cip->ci_description ),
				'street'			=> $cip->address,
				'postal_code'		=> $cip->postal_code,
				'cityid'			=> $this->aow_get_postid_from_meta( $cip->ci_city, 'cityid' ),
				'city'				=> $cip->city,
				'province'			=> $cip->ci_name_abbrev,
				'country'			=> 'Canada',
				'websiteurl'		=> $cip->url,
				'email'				=> $cip->office_email,
				'telephone'			=> $cip->phone,
				'fax'				=> $cip->fax,		    
				'lat_long' 			=> $this->aow_get_from_either_row( 'geo_coordinates', $cip ),
				'staff'				=> $this->aow_get_postid_from_meta( $cip->ci_doctors, 'staffid' ),
				'staff_list'		=> json_encode( $cip->staff_names ),
				'services'			=> $this->aow_get_postid_from_meta( $cip->ci_services, 'serviceid' ),
				'services_list'		=> json_encode( $cip->service_names ),
				'languages'			=> $this->aow_get_postid_from_meta( $cip->ci_languages, 'languageid' ),
				'languages_list'	=> json_encode( $cip->language_names ),
				'logo'				=> $cip->ci_logo,
				'image'				=> $cip->ci_image,
				'map'				=> $cip->ci_map,
				'facebookurl'		=> $cip->facebook,
				'virtual_tour'		=> $cip->google_tour,
				'twitterurl'		=> $cip->twitter,
				'twitterfull'		=> 'https://twitter.com/' . $cip->twitter,
				'youtubeid'			=> $this->aow_get_from_either_row( 'youtube', $cip ),
				'linked'			=> $this->aow_get_from_either_row( 'linkedin', $cip ),
				'yelp_id'			=> $this->aow_get_from_either_row( 'yelp_id', $cip ),
				'yelp_reviews_id'	=> $this->aow_get_from_either_row( 'yelp', $cip ),
				'cip'				=> json_encode( $cip ),
			);

			$meta_fields = $this->get_closure_status( $cip, $meta_fields );
			$meta_fields = $this->get_hours( $cip->ci_hours, 'all', $meta_fields );
			//var_dump( $meta_fields ); die();
		}
		return $meta_fields;
	}
	
	/**
	 * format time
	 * @param string $time
	 */
	public function get_hours( $array, $key, $meta_fields = FALSE ){
		$time_of_the_day = array();
		$tod_early = FALSE;
		$tod_business_hours = FALSE;
		$tod_late = FALSE;
		
		if( $meta_fields && is_array( $meta_fields ) ){
			$days = array(
				0 => 'mon',
				1 => 'tue',
				2 => 'wed',
				3 => 'thu',
				4 => 'fri',
				5 => 'sat',
				6 => 'sun',
			);
			foreach ( $days as $k => $v ){
				if( isset( $array[ $k ] ) ){
					if( (int)$array[$k][0] < 900 && $tod_early == FALSE ){ $time_of_the_day[] = 'early'; $tod_early = TRUE; }
					if( (int)$array[$k][0] < 1700 && $tod_business_hours == FALSE ){ $time_of_the_day[] = 'business_hours'; $tod_business_hours = TRUE; }
					if( (int)$array[$k][1] > 1700 && $tod_late == FALSE ){ $time_of_the_day[] = 'late'; $tod_late = TRUE; }
					
					$meta_fields[ $v ] = $this->formatTime( $array[ $k ] );
					$meta_fields[ $v . '_open' ] = ( $array[ $k ][ 2 ] == '0' ) ? $array[ $k ][ 0 ] : 'closed';
					$meta_fields[ $v . '_closed' ] = ( $array[ $k ][ 2 ] == '0' ) ? $array[ $k ][ 1 ] : 'closed';
					$meta_fields[ $v . '_msg' ] = ( $array[ $k ][ 2 ] == '2' ) ? $array[ $k ][ 3 ] : FALSE;
				}else{
					$meta_fields[ $v ] = 'Closed';
					$meta_fields[ $v . '_open' ] = 'closed';
					$meta_fields[ $v . '_closed' ] = 'closed';
					$meta_fields[ $v . '_msg' ] = FALSE;
				}
			}
			$meta_fields[ 'time_of_the_day' ] = $time_of_the_day;
			//var_dump( $meta_fields ); die();
			return $meta_fields;
		}
		$time = $this->formatTime( $array[ $key ] );
		return $time;
	}
	
	public function aow_get_from_either_row( $field = FALSE, $cip = FALSE ){
		$cip = ( $cip ) ? $cip : new stdClass();
		if( $field ){
			$ci_field = 'ci_' . $field;
			if( isset( $cip->$field ) ){
				$field = $cip->$field;
			}elseif( isset( $cip->$ci_field ) ){
				$field = $cip->$ci_field;
			}else{
				$field = FALSE;
			}
		}
		return $field;
	}
		
	public function formatTime($time)
	{		
		if ($time[2] == 1 or (!$time[0] and !$time[1])) {
			$hour = 'CLOSED';
			return $hour;
		}
		$open_time = number_format(($time[0]%2400)/100,2);
		$close_time = number_format(($time[1]%1200)/100,2);

		$openAP = ($time[0]<1200)?"AM":"PM";
		$closeAP = ($time[1]<1200)?"AM":"PM";	
		/*temp fix for 12:30 closing time problem */
		if ($time[1]==="1230") {$close_time = "12.30";}

		$open_time = str_replace(".",":",$open_time) . $openAP;
		$close_time = str_replace(".",":",$close_time) . $closeAP;		
		$note = (isset($time[3]) and $time[3])?" " . $time[3]:null;
		$hour = $open_time.' - '.$close_time . $note;

		return $hour;
	}
	
	public function aow_get_postid_from_meta( $meta_values = array( true ), $meta_key = FALSE ){
		if( !is_array( $meta_values ) ){ $meta_values = array( $meta_values ); }
		$post_ids = array();
		global $wpdb;
		if( is_array( $meta_values ) && $meta_key ){
			foreach( $meta_values as $meta_value ){	
				$results = $wpdb->get_results( "select post_id from $wpdb->postmeta where meta_key = '$meta_key' AND meta_value = '$meta_value'" );
				if( !empty( $results ) ){
					$post_ids[] = $results[ 0 ]->post_id;
				}
			}
		}
		return $post_ids;
	}
	
	public function get_closure_status( $cip, $meta_fields ){
		
		
		//'emergency_status'	=> $this->translate_temp_closure( $cip->ClinicInfoPackage->ClosureStatus->temporary_closure ),
		//	'emergency_message'	=> $cip->ClinicInfoPackage->ClosureStatus->closure_reason,
		
		if( property_exists( $cip, 'ClosureStatus' ) ){
			switch( $cip->ClosureStatus->temporary_closure ){
				case '0' :
					$closure_status = '1';
					break;
				case '1' :
					$closure_status = '3';
					break;
				default:
					$closure_status = '1';
			}
			
			$meta_fields[ 'emergency_status' ] = ( isset( $closure_status ) ) ? $closure_status : FALSE;
			$meta_fields[ 'emergency_message' ] = ( isset( $cip->ClosureStatus->closure_reason ) ) ? $cip->ClosureStatus->closure_reason : FALSE;
		}else if( property_exists( $cip, 'temporary_closure' ) ){
			switch( $cip->temporary_closure ){
				case '0' :
					$closure_status = '1';
					break;
				case '1' :
					$closure_status = '3';
					break;
				default:
					$closure_status = '1';
			}
			
			$meta_fields[ 'emergency_status' ] = $closure_status;
			$meta_fields[ 'emergency_message' ] = ( isset( $cip->closure_reason ) ) ? $cip->closure_reason : '';
		}
		
		
		
		/*
		on HUB
		0 : Open
		1 : Closed
		
		on 123Dentist
		1 : Open
		2 : Available On-Call
		3 : Temporarily Closed
		*/
		
		return $meta_fields;
	}

}
?>