<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://aheadoftheweb.com/
 * @since      1.0.0
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin/partials
 */
?>
<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<form action="<?php echo admin_url( 'admin-post.php', 'https' ); ?>" method="post">
<input type="hidden" name="action" value="get_data">
  <div id="aow-hub-node-wrapper" class="wrap">
	  <?php $is_active = 'class="aow-hub-node-global-nav-active"'; ?>
	  <ul id="aow-hub-node-global-nav">
		  <li><a <?php echo ( $this->current_section == 'default' ) ? $is_active : ''; ?> href="<?php echo admin_url( 'admin.php?page=aow_hub_node', 'https' ); ?>">Home</a></li>
		  <li><a <?php echo ( $this->current_section == 'hours' ) ? $is_active : ''; ?> href="<?php echo admin_url( 'admin.php?page=aow_hub_node_hours', 'https' ); ?>">Hours Options</a></li>
		  <li><a <?php echo ( $this->current_section == 'wptouch' ) ? $is_active : ''; ?> href="<?php echo admin_url( 'admin.php?page=aow_hub_node_wptouch', 'https' ); ?>">Reset WP Touch</a></li>
		  <li><a <?php echo ( $this->current_section == 'promo' ) ? $is_active : ''; ?> href="<?php echo admin_url( 'admin.php?page=aow_hub_node_promos', 'https' ); ?>">Promotions</a></li>
	  </ul>

  <div id="poststuff">
      <div id="post-body" class="metabox-holder columns-2">
          <!-- main content -->
          <div id="post-body-content">
              <?php $this->render_connection_status_message(); ?>
              <?php
			  switch( $this->current_section ){
				  case 'default':
					  $this->render_hub_node_section_body();
					  break;
				  case 'hours':
					  $this->render_hub_node_section_hours();
					  break;
				  case 'wptouch':
					  $this->render_hub_node_section_wptouch();
					  break;
				  case 'promo':
					  $this->render_hub_node_section_promo();
					  break;
				  default:
					  $this->render_hub_node_section_body();
				}
			  ?>
          </div>
          <!-- post-body-content -->
          <?php $this->render_hub_node_section_sidebar(); ?>
          <!-- #postbox-container-1 .postbox-container -->
      </div>
      <!-- #post-body .metabox-holder .columns-2 -->
      <br class="clear">
  </div>
  <!-- #poststuff -->
</div> <!-- .wrap -->
</form>
